/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.Minim;
import ddf.minim.javasound.BasicMetaData;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.javasound.JSPCMAudioRecordingStream;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.SampleRecorder;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioSystemShadow;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.file.AudioOutputStream;

final class JSStreamingSampleRecorder
implements SampleRecorder {
    private AudioOutputStream aos;
    private FloatSampleBuffer fsb;
    private String name;
    private AudioFileFormat.Type type;
    private AudioFormat format;
    private boolean recording;
    private JSMinim system;

    JSStreamingSampleRecorder(JSMinim jSMinim, String string, AudioFileFormat.Type type, AudioFormat audioFormat, int n) {
        this.name = string;
        this.type = type;
        this.format = audioFormat;
        this.system = jSMinim;
        try {
            this.aos = AudioSystemShadow.getAudioOutputStream(this.type, this.format, -1L, new File(this.name));
        }
        catch (IOException iOException) {
            this.system.error("Error obtaining new output stream: " + iOException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.system.error("Error obtaining new output stream for " + string + " with type " + this.type.toString() + " format " + this.format.toString() + " and bufferSize " + n + ".\n" + "The reason is " + illegalArgumentException.getMessage());
        }
        this.fsb = new FloatSampleBuffer(this.format.getChannels(), n, this.format.getSampleRate());
        this.recording = false;
    }

    @Override
    public String filePath() {
        return this.name;
    }

    @Override
    public void beginRecord() {
        this.recording = true;
    }

    @Override
    public void endRecord() {
        this.recording = false;
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public AudioRecordingStream save() {
        try {
            this.aos.close();
        }
        catch (IOException iOException) {
            Minim.error("AudioRecorder.save: An error occurred when trying to save the file:\n" + iOException.getMessage());
        }
        String string = this.filePath();
        AudioInputStream audioInputStream = this.system.getAudioInputStream(string);
        SourceDataLine sourceDataLine = this.system.getSourceDataLine(audioInputStream.getFormat(), 1024);
        long l = AudioUtils.frames2Millis(audioInputStream.getFrameLength(), this.format);
        BasicMetaData basicMetaData = new BasicMetaData(string, l, audioInputStream.getFrameLength());
        JSPCMAudioRecordingStream jSPCMAudioRecordingStream = new JSPCMAudioRecordingStream(this.system, basicMetaData, audioInputStream, sourceDataLine, 1024);
        return jSPCMAudioRecordingStream;
    }

    @Override
    public void samples(float[] fArray) {
        if (this.recording) {
            System.arraycopy(fArray, 0, this.fsb.getChannel(0), 0, fArray.length);
            byte[] byArray = this.fsb.convertToByteArray(this.format);
            try {
                this.aos.write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                Minim.error("AudioRecorder: An error occurred while trying to write to the file:\n" + iOException.getMessage());
            }
        }
    }

    @Override
    public void samples(float[] fArray, float[] fArray2) {
        if (this.recording) {
            System.arraycopy(fArray, 0, this.fsb.getChannel(0), 0, fArray.length);
            System.arraycopy(fArray2, 0, this.fsb.getChannel(1), 0, fArray2.length);
            byte[] byArray = this.fsb.convertToByteArray(this.format);
            try {
                this.aos.write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                Minim.error("AudioRecorder: An error occurred while trying to write to the file:\n" + iOException.getMessage());
            }
        }
    }
}

